import logging
from typing import TYPE_CHECKING

from rq import Connection, Worker

if TYPE_CHECKING:
    from typing import Any

    from redis import Redis


log = logging.getLogger(__name__)


class RedisQueueProcessor:  # pylint: disable=R0903
    """To be used as a background process target
    (squirro/common/background.py).

    Connects to Redis and waits for incoming messages. As soon as they
    arrive, it executes whatever was specified as a task in rq.enqueue.
    """

    def __init__(self, redis: "Redis[bytes]", queueus: "list[str]") -> None:
        self.redis = redis
        self.queueus_to_observe = queueus
        self.should_stop = False

    def run(self, _tokens: int = 1, **kwargs: "Any") -> None:  # pylint: disable=W0613
        log.info("redis worker running")
        with Connection(self.redis):
            worker = Worker(self.queueus_to_observe, connection=self.redis)
            worker.work()
        log.info("redis worker running finished")
