class SquirroProjectNotFound(Exception):
    """When no project config is found."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)


class DocumentNotFound(Exception):
    """When document is not found in SQL."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)


class UserNotFound(Exception):
    """When user or active session is not found."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)


class InvalidStatus(Exception):
    """When Status transitions reference non-existing status."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)


class InvalidRequest(Exception):
    """When some requirement isnt met."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)


class AccessNotAllowed(Exception):
    """When user is not allowed to access status tracking."""

    def __init__(self, message: str) -> None:
        self.message = message
        super().__init__(self.message)
