/**
 * Creates a panel to view and update status tracking configuration.
 */
return StudioPlugins.Base.extend({
    index: Pages.StudioBase.extend({
        FULL_WIDTH: true,
        maskOverlayedLoader: _.noop,

        form: [
            {
                view: Properties.Text,
                config: {
                    inputName: "project_id",
                    infoText: "Project Identifier",
                },
            },
            {
                view: Properties.Text,
                config: {
                    inputName: 'version',
                    infoText: 'Config Version',
                },
            },
            {
                view: Properties.MultilineText,
                config: {
                    inputName: 'status_map',
                    infoText: 'Status config',
                },
            },
            {
                view: Properties.StudioButton,
                config: {
                    inputName: "saveConfig",
                    text: "Save Status Tracking Config",
                }
            }
        ],
        events: {
            'click input[name="saveConfig"]': "_saveConfig",
        },

        render: function () {
            const rendered = Pages.StudioBase.prototype.render.apply(this, arguments);
            this.overlayLoader();
            this.$('[name="status_map"]').height(600).css({
                'overflow': 'scroll'
            });
            const project_id = this.options.project.get('id');

            $.ajax({
                url: `/studio/document_status_tracking/projects/${project_id}/config`,
                dataType: 'json',
                cache: false,
                success: _.bind(function (data) {
                    this.hideOverlayedLoader();
                    this._updateView(data.config)
                }, this),
                error: _.bind(function (e) {
                    this.hideOverlayedLoader();
                    if (e.status == 404) {
                        Materialize.toast('Status tracking not yet configured', 3000);
                        this._updateView({
                            project_id,
                            version: 1,
                            status_map: { access_roles: [], statuses: [], transitions: {} }
                        });
                    } else {
                        Materialize.toast('Failed to fetch: ' + e.responseJSON.message, 5000);
                    }
                }, this),

            });
            return rendered;
        },
        _updateView: (config) => {
            this.$('input[name="project_id"]').val(config.project_id);
            this.$('input[name="version"]').val(config.version);
            this.$('[name="status_map"]').val(JSON.stringify(config.status_map, null, 4));
        },
        _saveConfig: (e) => {
            _.halt(e);
            const req = this.$("form").serializeObject();
            try {
                req.status_map = JSON.parse(req.status_map);
            } catch (error) {
                Materialize.toast('Failed to read config: ' + error, 10000);
                return;
            }
            req.version++;
            $.ajax({
                method: 'POST',
                url: `/studio/document_status_tracking/projects/${req.project_id}/config`,
                data: JSON.stringify(req),
                contentType: 'application/json',
                success: _.bind(function (response) {
                    Materialize.toast('Config successfully saved.', 3000, 'rounded');
                    // this not bound to view instance
                    this.$('input[name="version"]').val(response.config.version);
                    this.$('[name="status_map"]').val(JSON.stringify(response.config.status_map, null, 4));
                }, this),
                error: _.bind(function (e) {
                    Materialize.toast('Update failed: ' + e.responseJSON.message, 10000);
                }, this),
            });
        },

    }),
});
