#!/bin/bash

if [ -z "${SESSION}" ]; then
	echo "Error: set SESSION envvar - cookie for authentication." >&2
	exit 1
fi

export URL=https://ocbc-dev.squirro.cloud/studio/document_status_tracking
export DOCUMENT="uwFfuOGYGjbeYe3KwbHnXA"
export PROJECT="XbseNpyKRnKZxV8bvbFyMw"

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/config" \
	-H 'content-type: application/json' \
	--data @- <<EOT
  {"project_id":"$PROJECT","version":1,"status_map":{"access_roles": [
    "Workbench: CSSupportChecker",
    "Workbench: CSSupportMaker",
    "iLMS:BBCACSOChecker",
    "iLMS:BBCACSOMaker",
    "iLMS:BLTOfficer"
  ],"statuses":[{"code":"001","description":"Original scanned and held by Central Services.","final":false,"header":"File created from original hard copy","remarks":"optional"},{"code":"001Z","description":"Reviewed original document scanned by Central Services.","final":false,"header":"Reviewed file created from original hard copy","remarks":"optional"},{"code":"001A","description":"BBCA Document to be reviewed by BBCA CSO.","final":false,"header":"Action required by BBCA CSO.","remarks":"disabled"},{"code":"001B","description":"Project-related document to be reviewed by BBCA \u2013 CST","final":false,"header":"Action required by BBCA \u2013 Credit Services Team (\u201cCST\u201d)","remarks":"optional"},{"code":"001C","description":"BBCA CSO / BBCA \u2013 Credit Services Team (CST) has rejected documents, to be returned to BU for rectification. (Non-BBCA documents) Central Services Checker rejected documents, to be returned to BU for rectification.","final":false,"header":"Return to BU","remarks":"optional"},{"code":"001D","description":"Personnel from BU has retrieved the documents from Central Services","final":false,"header":"Picked up by BU","remarks":"mandatory"},{"code":"001E","description":"Central Services to pass the original documents to BBCA-CSO.","final":false,"header":"Return to BBCA-CSO","remarks":"optional"},{"code":"001F","description":"Personnel from BBCA-CSO has received the documents from Central Services.","final":false,"header":"Picked up by BBCA-CSO","remarks":"optional"},{"code":"002A1","description":"BBCA-CSO to pass the original documents to Central Services","final":false,"header":"Documents returned from BBCA-CSO Lodgment required","remarks":"optional"},{"code":"002A","description":"BBCA CSO requires document to be lodged in CLIMS.","final":false,"header":"Lodgment required","remarks":"optional"},{"code":"002B","description":"Document lodged in CLIMS and sent to custodian (Iron Mountain) for safekeeping.","final":false,"header":"Lodged in CLIMS and sent to custodian","remarks":"optional"},{"code":"002B1","description":"Document lodged in CLIMS for eUpload.","final":true,"header":"Lodged in CLIMS - eUpload","remarks":"optional"},{"code":"002C","description":"Iron Mountain perform the update in CLIMS safekeeping in Vault.","final":true,"header":"Safekept in vault","remarks":"optional"},{"code":"003A","description":"Document does not require lodgment in CLIMS.","final":false,"header":"Lodgment not required","remarks":"optional"},{"code":"003A1","description":"BBCA-CSO to pass the original documents to Central Services. Document does not require lodgment in CLIMS.","final":false,"header":"Documents returned from BBCA-CSO. Lodgment not required","remarks":"optional"},{"code":"003B","description":"Sent to Iron Mountain for archival.","final":true,"header":"Archived (non-vault)","remarks":"optional"},{"code":"004","description":"Ingested through email upload","final":false,"header":"Email upload","remarks":"optional"},{"code":"005","description":"Ingested through web upload","final":false,"header":"Web upload","remarks":"optional"},{"code":"006","description":"Ingested through API upload","final":true,"header":"End point upload","remarks":"optional"},{"code":"007","description":"?","final":true,"header":"Migrated document from WFI","remarks":"?"},{"code":"AT001","description":"From <> to <>","final":false,"header":"company name changed","remarks":"forbidden"},{"code":"AT002","description":"From <> to <>","final":false,"header":"Document type changed","remarks":"forbidden"},{"code":"AT003","description":"From <> to <>","final":false,"header":"Document date changed","remarks":"forbidden"},{"code":"901","description":"Document does not have the following categories: company name, doc type","final":false,"header":"Unclassified document (missing company name and type)","remarks":"forbidden"},{"code":"902","description":"Document does not have the following categories: company name, doc date","final":false,"header":"Unclassified document (missing company name and date)","remarks":"forbidden"},{"code":"903","description":"Document does not have the following categories: doc type, doc date","final":false,"header":"Unclassified document (missing type and date)","remarks":"forbidden"},{"code":"904","description":"Document does not have the following categories: company name","final":false,"header":"Unclassified document (missing company name)","remarks":"forbidden"},{"code":"905","description":"Document does not have the following categories: doc type","final":false,"header":"Unclassified document (missing type)","remarks":"forbidden"},{"code":"906","description":"Document does not have the following categories: doc date","final":false,"header":"Undated document","remarks":"forbidden"},{"code":"907","description":"Document does not have the following categories: company name, doc type and doc date","final":false,"header":"Unclassified document (missing all)","remarks":"forbidden"}],"transitions":{"001":{"001":{"CS Maker":["BBCA","non-BBCA"]},"001A":{"CS Checker":["BBCA"]},"001B":{"BBCA-CSO Checker":["BBCA"],"CS Checker":["BBCA"]},"001Z":{"CS Checker":["non-BBCA"],"CS Maker":["BBCA"]},"002A":{"BBCA-CSO Checker":["BBCA"]}},"001A":{"001C":{"BBCA-CSO Checker":["BBCA"],"CS Checker":["non-BBCA"]},"001E":{"CS Checker":["non-BBCA","BBCA"]},"002A1":{"BBCA-CSO Checker":["BBCA"]}},"001B":{"001B":{"BBCA-CSO Checker":["BBCA"],"CS Checker":["non-BBCA"]},"001C":{"BBCA-CSO Checker":["BBCA"],"CS Checker":["non-BBCA"]}},"001C":{"001C":{"BBCA-CSO Checker":["BBCA"],"CS Checker":["non-BBCA"]},"001D":{"CS Checker":["non-BBCA","BBCA"]}},"001D":{"001D":{"CS Checker":["non-BBCA","BBCA"]},"?":{"":["non-BBCA","BBCA"]}},"001E":{"001E":{"CS Checker":["non-BBCA","BBCA"]},"001F":{"BBCA-CSO Checker":["BBCA","non-BBCA"]}},"001F":{"001D":{"BBCA-CSO Checker":["BBCA"]},"001F":{"BBCA-CSO Checker":["BBCA","non-BBCA"]},"002A1":{"BBCA-CSO Checker":["BBCA"]},"003A1":{"BBCA-CSO Checker":["BBCA"]}},"001Z":{"001C":{"CS Checker":["non-BBCA"]},"001Z":{"CS Maker":["BBCA","non-BBCA"]},"003B":{"CS Checker":["non-BBCA"]}},"002A":{"002A":{"BBCA-CSO Checker":["BBCA"]},"002B":{"CS Checker":["BBCA"]},"002B1":{"CS Checker":["BBCA"]}},"002A1":{"002A1":{"BBCA-CSO Checker":["BBCA"]},"002B":{"CS Checker":["BBCA"]},"002B1":{"CS Checker":["BBCA"]}},"002B":{"002B":{"CS Checker":["BBCA"]},"002C":{"CS Checker":["BBCA"]}},"002B1":{"002B1":{"CS Checker":["BBCA"]}},"002C":{"002C":{"CS Checker":["BBCA"]}},"003A":{"003A":{"BBCA-CSO Checker":["BBCA"]},"003B":{"CS Checker":["BBCA"]}},"003A1":{"003A1":{"BBCA-CSO Checker":["BBCA"]},"003B":{"CS Checker":["BBCA"]}},"003B":{"003B":{"CS Checker":["BBCA"]}},"901":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"902":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"903":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"904":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"905":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"906":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}},"907":{"001":{"BBCA-CSO Checker":["BBCA","non-BCA"],"BBCA-CSO Maker":["BBCA","non-BCA"]}}}}}
EOT

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/config"

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents" \
	-H 'content-type: application/json' \
	--data @- <<EOT
  {
    "document_id": "$DOCUMENT",
    "project_id": "$PROJECT",
    "document_type": "BANK GUARANTEE/SBLC",
    "company_name": "ACME Corp",
    "document_date": "11/04/2024",
    "source_type": "User Upload",
    "updater": {
      "uid":["johndoe@example.com"],
      "lan_id":["A001"],
      "name":"John Doe",
      "role_ocbc":["iLMS:BBCACSOMaker"]
    }
}
EOT

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents/$DOCUMENT"

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents/$DOCUMENT/status" \
	-H 'content-type: application/json' \
	--data '{
    "status_code":"002A"
}'

curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents-bulk-status" \
	-H 'content-type: application/json' \
	--data '
  {
    "status_code":"003A1",
    "document_ids": ["zGXYD8d_5k5-9xZ7PAbV7f", "zFyaL3_DSTvZ8fsrwZI3Ww"]
  }
'

# To triger AT00x status update:
curl -v -X PUT -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents/$DOCUMENT" \
	-H 'content-type: application/json' \
	--data '{"document_date":"09/01/2024","company_name":"2U, Inc."}'

# batch import
curl -v -H "cookie: $SESSION" "$URL/projects/$PROJECT/documents-batch" \
	-H 'content-type: application/json' \
	--data '
  [{
    "document_id": "1hBIoUSbvGy_5rqck3p7wA",
    "document_type": "ASSIGNMENT",
    "company_name": "1347 Property",
    "document_date": "27/10/2023"
},{
    "document_id": "DzpOGe6n3O-O4SNdTQL6rg",
    "document_type": "TITLE DEED",
    "company_name": "2U. Inc",
    "document_date": "27/10/2023"
}
]'
