# pylint: disable=invalid-name # because filename starts with a number
"""Add document status table.

Generated by alembic and then manually adjusted.

Revision ID: 6dd1003e9818
Revises: 52a02d703b95
Create Date: 2023-12-27 14:52:13.038640
"""

from typing import TYPE_CHECKING

import sqlalchemy as sa
from alembic import op

if TYPE_CHECKING:
    from collections.abc import Sequence

# revision identifiers, used by Alembic.
revision: str = "6dd1003e9818"
down_revision: "str | None" = "52a02d703b95"
branch_labels: "str | Sequence[str] | None" = None
depends_on: "str | Sequence[str] | None" = None


def upgrade() -> None:
    op.create_table(  # pylint: disable=no-member # false positive
        "document_status",
        sa.Column("document_id", sa.String(length=50), nullable=False),
        sa.Column("company_name", sa.String(length=4092), nullable=True),
        sa.Column("document_type", sa.String(length=250), nullable=True),
        sa.Column("document_date", sa.String(length=250), nullable=True),
        sa.Column("project_id", sa.String(length=50), nullable=False),
        sa.Column("status_trail", sa.JSON(), nullable=True),
        # for more efficient queries store current status in a separate column:
        sa.Column("status_code", sa.String(length=50), nullable=True),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("document_id"),
    )
    op.create_index(  # pylint: disable=no-member # false positive
        "idx_upd_code",
        "document_status",
        ["updated", "status_code"],
        unique=False,
    )


def downgrade() -> None:
    op.drop_index(  # pylint: disable=no-member # false positive
        "idx_upd_code", table_name="document_status"
    )
    op.drop_table("document_status")  # pylint: disable=no-member # false positive
