# pylint: disable=invalid-name # because filename starts with a number
"""Add status tracking configuration table.

Generated by alembic and then manually adjusted.

Revision ID: 52a02d703b95
Revises:
Create Date: 2023-12-21 11:42:00.879506
"""

from typing import TYPE_CHECKING

import sqlalchemy as sa
from alembic import op

if TYPE_CHECKING:
    from collections.abc import Sequence


# revision identifiers, used by Alembic.
revision: str = "52a02d703b95"
down_revision: "str | None" = None
branch_labels: "str | Sequence[str] | None" = None
depends_on: "str | Sequence[str] | None" = None


def upgrade() -> None:
    op.create_table(  # pylint: disable=no-member # false positive
        "status_tracking_config",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.String(length=50), nullable=False),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.Column("status_map", sa.JSON(), nullable=True),
        sa.Column("updated", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("project_id", "version", name="unq_version_per_project"),
    )


def downgrade() -> None:
    op.drop_table(  # pylint: disable=no-member # false positive
        "status_tracking_automata"
    )
