import logging

from alembic import context
from sqlalchemy import create_engine

from octopus.utils import load_config
from squirro.common.dependency import get_injected

log = logging.getLogger("alembic.env")


def run_migrations() -> None:
    log.warning("running migrations")
    try:
        session = get_injected("db_studio")
        if not session:
            log.error("Failed to run migrations, no db engine found")
            return
        engine = session.bind.engine
        target_metadata = None
    except Exception:
        # pylint: disable-next=import-outside-toplevel
        from status_tracking.models import Base

        # Generate migration as get_injected will only work as studio plugin
        cfg = load_config("/etc/squirro/frontend.ini")
        engine = create_engine(cfg["studio"]["db"])
        target_metadata = Base.metadata

    with engine.connect() as connection:
        context.configure(  # pylint: disable=no-member # false positive
            connection=connection, target_metadata=target_metadata
        )

        with context.begin_transaction():  # pylint: disable=no-member
            context.run_migrations()  # pylint: disable=no-member
    log.info("migrations done")


# always runs as a module
run_migrations()
