import json

import pytest
from track_items import TrackItems


class TestTrackItemsPipelet:
    def setup_method(self):
        self.track_items_pipelet = TrackItems({})

    def test_track_user_uploaded_items(self, item):
        item["keywords"] = {
            "source_type": ["User Upload"],
            "user_email": ["john.doe@gmail.com"],
            "user_name": ["John Doe"],
        }

        self.track_items_pipelet.consume(item)

        self.track_items_pipelet.redis_client.hset.assert_called_once_with(
            "item_status_hash",
            "item-id",
            json.dumps(
                {
                    "id": "item-id",
                    "title": "Item Title",
                    "created_at": "2012-12-12T12:12:12",
                    "source_type": ["User Upload"],
                    "user_email": ["john.doe@gmail.com"],
                    "user_name": ["John Doe"],
                }
            ),
        )

    def test_track_wfi_items(self, item):
        item["keywords"] = {
            "source_type": ["WFI Historic"],
        }

        self.track_items_pipelet.consume(item)

        self.track_items_pipelet.redis_client.hset.assert_called_once_with(
            "item_wfi_status_hash",
            "item-id",
            json.dumps(
                {
                    "id": "item-id",
                    "title": "Item Title",
                    "created_at": "2012-12-12T12:12:12",
                    "source_type": ["WFI Historic"],
                }
            ),
        )


@pytest.fixture
def item():
    return {
        "id": "item-id",
        "title": "Item Title",
        "created_at": "2012-12-12T12:12:12",
        "keywords": {},
    }
