"""Track time taken for each item."""

import time
from typing import TYPE_CHECKING

from squirro.sdk import PipeletV1, require

if TYPE_CHECKING:
    from logging import Logger
    from typing import Any


@require("log")
class TimeItemPipelet(PipeletV1):  # type: ignore[misc]
    """Pipelet to log item for debugging."""

    log: "Logger"

    def consume(self, item: "dict[str, Any]") -> "dict[str, Any]":
        """Consume an item.

        Args:
            item: The item to consume

        Returns:
            The consumed item
        """
        if "start_time" not in item["keywords"]:
            item["keywords"]["start_time"] = [int(time.time())]
            return item
        item["keywords"]["end_time"] = [int(time.time())]
        item["keywords"]["time_taken"] = (
            item["keywords"]["end_time"][0] - item["keywords"]["start_time"][0]
        )
        self.log.info("Time taken for item %s", item["keywords"]["time_taken"])
        return item
