from unittest.mock import Mock

import pytest
from refine_activity_item import RefineActivityItem


class TestRefineActivityItem:
    def test_refine_activity_item(self, item_fixture: "dict") -> "None":
        config: Mock = Mock()
        test = RefineActivityItem(config)
        item_refined: dict = test.consume(item_fixture)
        assert item_refined == {
            "id": "123",
            "title": "Five nights at Freddy's",
            "keywords": {
                "source_type": ["Microsoft Exchange"],
                "user_email": ["htet.naing@dota.in"],
                "user_name": ["Htet"],
            },
        }

    def test_no_refine_case(self, no_refine_item: "dict") -> "None":
        config: Mock = Mock()
        test = RefineActivityItem(config)
        item_refined: dict = test.consume(no_refine_item)

        assert item_refined == no_refine_item


@pytest.fixture
def item_fixture() -> "dict":
    return {
        "id": "123",
        "title": "Five nights at Freddy's",
        "keywords": {
            "source_type": ["Microsoft Exchange"],
            "Email": ["htet.naing@dota.in"],
            "Name": ["Htet"],
        },
    }


@pytest.fixture
def no_refine_item() -> "dict":
    return {
        "id": "123",
        "title": "Five nights at Freddy's",
        "keywords": {
            "source_type": ["Microsoft Exchange"],
            "user_email": ["htet.naing@dota.in"],
            "user_name": ["Htet"],
        },
    }
