"""Refine activity item."""

import re
from typing import TYPE_CHECKING

from squirro.sdk import PipeletV1, require

if TYPE_CHECKING:
    from re import Pattern
    from typing import Any


@require("log")
class RefineActivityItem(PipeletV1):  # type: ignore[misc]
    """Refine activity item."""

    def consume(self, item: "dict[str, Any]") -> "dict[str, Any]":  # noqa: PLR6301
        """Consume an item.

        Args:
            item: The item to consume

        Returns:
            The consumed item
        """
        if "user_name" not in item.get("keywords", {}):
            item["keywords"]["user_name"] = item.get("keywords", {}).get("Name", [])
            item["keywords"]["user_email"] = item.get("keywords", {}).get("Email", [])

        if "Name" in item.get("keywords", {}) and "Email" in item.get("keywords", {}):
            del item["keywords"]["Name"]
            del item["keywords"]["Email"]

        if title := item.get("keywords", {}).get("item_title", [""])[0]:
            pattern_html: str = r"<\/?[^><]+>"
            pattern: Pattern[str] = re.compile(pattern_html)
            title = pattern.sub("", title)
            item["keywords"]["item_title"] = title
            item["title"] = title

        return item
