import pytest
from map_wfi_labels_to_squirro import MapWFILabelsToSquirro


class TestMapWFILabelsToSquirro:
    def setup_method(self):
        self.pipelet = MapWFILabelsToSquirro({})

    def test_tag_company_name(self, item):
        data = self.pipelet._tag_company_name(item)

        assert data["company_name_true"] == ["Company B"]

    def test_tag_company_name_no_search_result(self, item, caplog):
        item["keywords"]["wfi_company_cif"] = ["00000"]
        data = self.pipelet._tag_company_name(item)

        assert "Company with cif `00000` for item `1234` does not exist." in caplog.text
        assert data == {}

    def test_tag_company_name_search_result_no_company_name(self, item, caplog):
        item["keywords"]["wfi_company_cif"] = ["no company name"]
        data = self.pipelet._tag_company_name(item)

        assert (
            "Company with cif `no company name` for item `1234` does not have a company name."
            in caplog.text
        )
        assert data == {}

    def test_tag_company_name_no_wfi_company_cif(self, item_no_wfi_company_cif, caplog):
        data = self.pipelet._tag_company_name(item_no_wfi_company_cif)

        assert "Item `1234` does not contain valid wfi_company_cif." in caplog.text
        assert data == {}

    def test_tag_document_date(self, item):
        data = self.pipelet._tag_document_date(item)

        assert data["document_date_true"] == ["2020-01-01"]

    def test_tag_document_date_no_wfi_document_date(
        self, item_no_wfi_document_date, caplog
    ):
        data = self.pipelet._tag_document_date(item_no_wfi_document_date)

        assert "Item `1234` does not contain wfi_document_date." in caplog.text
        assert data == {}

    def test_tag_document_date_invalid_wfi_document_date(
        self, item_invalid_wfi_document_date, caplog
    ):
        data = self.pipelet._tag_document_date(item_invalid_wfi_document_date)

        assert (
            "Failed to parse document date `01-January-2020 00:00:00` for item `1234`."
        ) in caplog.text
        assert data == {}

    def test_tag_document_type(self, item):
        data = self.pipelet._tag_document_type(item)

        assert data["document_type_true"] == ["OTHER AGREEMENT"]

    def test_tag_document_type_no_wfi_document_name(
        self, item_no_wfi_document_name, caplog
    ):
        data = self.pipelet._tag_document_type(item_no_wfi_document_name)

        assert "Item `1234` does not contain valid wfi_document_name." in caplog.text
        assert data == {}

    def test_consume(self, item):
        self.pipelet.consume(item)

        assert item["keywords"]["company_name_true"] == ["Company B"]
        assert item["keywords"]["document_date_true"] == ["2020-01-01"]
        assert item["keywords"]["document_type_true"] == ["OTHER AGREEMENT"]


@pytest.fixture
def item():
    return {
        "id": "1234",
        "keywords": {
            "wfi_document_date": ["01-Jan-2020 00:00:00"],
            "wfi_document_name": ["Accession Agreement"],
            "wfi_company_cif": ["11111"],
        },
    }


@pytest.fixture
def item_invalid_wfi_document_date(item):
    item["keywords"]["wfi_document_date"] = ["01-January-2020 00:00:00"]
    return item


@pytest.fixture
def item_no_wfi_company_cif(item):
    item["keywords"].pop("wfi_company_cif")
    return item


@pytest.fixture
def item_no_wfi_document_date(item):
    item["keywords"].pop("wfi_document_date")
    return item


@pytest.fixture
def item_no_wfi_document_name(item):
    item["keywords"].pop("wfi_document_name")
    return item
