# ruff: noqa
# from unittest import TestCase
# from unittest.mock import MagicMock, patch

# from filter_items import CONFIG_FILE_PATH, FilterItems
# from pdfminer.pdfdocument import PDFPasswordIncorrect

# REDIS_ITEM_REJECTION_HASH = "item_rejection_hash"


# class MockedPDFDocument:
#     def __init__(self, is_extractable):
#         self.is_extractable = is_extractable


# class TestFilterItems(TestCase):
#     item_sender_email = ["test.user@squirro.com"]

#     @patch(
#         "filter_items.FilterItems._get_whitelisted_emails",
#         return_value=item_sender_email,
#     )
#     @patch("redis.StrictRedis")
#     @patch("squirro_client.SquirroClient")
#     @patch("configparser.ConfigParser.get")
#     @patch("configparser.ConfigParser.read", return_value=[CONFIG_FILE_PATH])
#     def setUp(
#         self,
#         mock_read,
#         mock_get,
#         mock_squirroclient,
#         mock_strictredis,
#         mock_get_whitelisted_emails,
#     ):
#         self.file_path = "/storage/localfile/document.txt"

#         self.filter_items = FilterItems({})
#         self.filter_items.sq_client.get_users.return_value = {
#             "users": [
#                 {"name": "John Doe", "email": "john.doe@squirro.com"},
#                 {"name": "Test User", "email": "TeSt.UsEr@SqUiRrO.cOm"},
#             ]
#         }
#         self.filter_items.sq_client.get_project_configuration.return_value = {
#             "config": {
#                 "app.whitelisted-emails": {
#                     "value": {
#                         "email_addresses": [
#                             "JoE.sChMoE@sQuIrRo.CoM",
#                             "jane.smith@squirro.com",
#                         ]
#                     }
#                 }
#             }
#         }

#     def test_get_whitelisted_emails_without_user_emails(self):
#         self.filter_items.sq_client.get_users.return_value = {}

#         assert self.filter_items._get_whitelisted_emails() == [
#             "joe.schmoe@squirro.com",
#             "jane.smith@squirro.com",
#         ]

#     def test_get_whitelisted_emails_without_config_emails(self):
#         self.filter_items.sq_client.get_project_configuration.return_value = {}

#         assert self.filter_items._get_whitelisted_emails() == [
#             "john.doe@squirro.com",
#             "test.user@squirro.com",
#         ]

#     def test_get_whitelisted_emails(self):
#         assert self.filter_items._get_whitelisted_emails() == [
#             "john.doe@squirro.com",
#             "test.user@squirro.com",
#             "joe.schmoe@squirro.com",
#             "jane.smith@squirro.com",
#         ]

#     def test_add_item_rejection(self):
#         item_id = "1234567890"
#         rejection_id = "0987654321"

#         self.filter_items._add_item_rejection(item_id, rejection_id)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, item_id, rejection_id
#         )

#     @patch("configparser.ConfigParser.get", return_value="/storage/localfile")
#     def test_get_file_path(self, mock_get):
#         assert self.filter_items._get_file_path({}) == self.file_path

#     def test_is_password_protected_with_empty_mime_type(self):
#         assert self.filter_items._is_password_protected(self.file_path, "") is False

#     def test_is_password_protected_with_unsupported_mime_type(self):
#         assert (
#             self.filter_items._is_password_protected(self.file_path, "image/jpeg")
#             is False
#         )

#     @patch("filter_items.PDFDocument", return_value=MockedPDFDocument(False))
#     @patch("filter_items.PDFParser")
#     @patch("builtins.open")
#     def test_is_password_protected_with_pdf_mime_type(
#         self, mock_open, mock_pdfparser, mock_pdfdocument
#     ):
#         assert (
#             self.filter_items._is_password_protected(self.file_path,
#                "application/pdf")
#             is True
#         )

#     @patch("builtins.open")
#     def test_is_password_protected_with_pdf_password_incorrect(self, mock_open):
#         mock_open.side_effect = PDFPasswordIncorrect()

#         assert (
#             self.filter_items._is_password_protected(self.file_path,
#               "application/pdf")
#             is True
#         )


# class TestFilterItemsIsValidItem(TestCase):
#     item_sender_email = ["test.user@squirro.com"]

#     @patch(
#         "filter_items.FilterItems._get_whitelisted_emails",
#         return_value=item_sender_email,
#     )
#     @patch("redis.StrictRedis")
#     @patch("squirro_client.SquirroClient")
#     @patch("configparser.ConfigParser.get")
#     @patch("configparser.ConfigParser.read", return_value=[CONFIG_FILE_PATH])
#     def setUp(
#         self,
#         mock_read,
#         mock_get,
#         mock_squirroclient,
#         mock_strictredis,
#         mock_get_whitelisted_emails,
#     ):
#         self.path = "/storage/localfile/test_file.pdf"
#         self.item_id = "1234567890"
#         self.file = {
#             "name": "test_file.pdf",
#             "mime_type": "application/pdf",
#         }
#         self.item = {
#             "id": self.item_id,
#             "files": [self.file],
#             "keywords": {
#                 "user_email": self.item_sender_email,
#                 "source_type": ["Email"],
#             },
#         }

#         self.filter_items = FilterItems({})
#         self.filter_items._get_file_path = MagicMock(return_value=self.path)
#         self.filter_items._is_password_protected = MagicMock(return_value=False)
#         self.filter_items._remove_file = MagicMock()

#     def test_is_valid_item_without_item_id(self):
#         self.item.pop("id")

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     def test_is_valid_item_with_empty_item_id(self):
#         self.item.update({"id": ""})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     def test_is_valid_item_without_item_files(self):
#         self.item = {"id": self.item_id}

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20003
#         )
#         assert is_valid_item is False

#     def test_is_valid_item_with_empty_item_files(self):
#         self.item.update({"files": []})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20003
#         )
#         assert is_valid_item is False

#     def test_is_valid_item_with_invalid_file_path(self):
#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20000
#         )
#         assert is_valid_item is False

#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_password_protected_file(self, mock_isfile):
#         self.filter_items._is_password_protected.return_value = True

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20002
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=55_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_file_size_exceeding_default_value(
#         self, mock_isfile, mock_getsize
#     ):
#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20001
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=55_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_file_size_exceeding_default_value_2(
#         self, mock_isfile, mock_getsize
#     ):
#         self.filter_items.config = {"filter_exceeding_size_files": 100}

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20001
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=15_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_file_size_exceeding_provided_value(
#         self, mock_isfile, mock_getsize
#     ):
#         self.filter_items.config = {"filter_exceeding_size_files": 10}

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20001
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_unsupported_mime_type
#        (self, mock_isfile, mock_getsize):
#         file = {"name": "test_file.zip", "mime_type": "application/zip"}
#         self.item.update({"files": [file]})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20004
#         )
#         self.filter_items._remove_file.assert_called_once_with(file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_without_sender_email(self, mock_isfile, mock_getsize):
#         self.item = {
#             "id": self.item_id,
#             "files": [self.file],
#             "keywords": {"source_type": ["Email"]},
#         }

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20005
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_empty_sender_email(self, mock_isfile, mock_getsize):
#         self.item.update({"keywords": {"user_email": [""], "source_type": ["Email"]}})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20005
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_not_whitelisted_sender_email(
#         self, mock_isfile, mock_getsize
#     ):
#         self.item.update(
#             {
#                 "keywords": {
#                     "user_email": ["user@squirro.com"],
#                     "source_type": ["Email"],
#                 }
#             }
#         )

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         self.filter_items.redis_client.hset.assert_called_once_with(
#             REDIS_ITEM_REJECTION_HASH, self.item_id, 20005
#         )
#         self.filter_items._remove_file.assert_called_once_with(self.file, self.path)
#         assert is_valid_item is False

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_case_insensitive_sender_email(
#         self, mock_isfile, mock_getsize
#     ):
#         self.item.update({"keywords": {"user_email": ["Test.User@Squirro.Com"]}})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         assert is_valid_item is True

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item(self, mock_isfile, mock_getsize):
#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         assert is_valid_item is True

#     @patch("os.path.getsize", return_value=50_000_000)
#     @patch("os.path.isfile", return_value=True)
#     def test_is_valid_item_with_user_upload_source_type(
#         self, mock_isfile, mock_getsize
#     ):
#         self.item.update({"keywords": {"source_type": ["User Upload"]}})

#         is_valid_item = self.filter_items._is_valid_item(self.item)

#         assert is_valid_item is True
