"""Check item pipelet."""

from typing import TYPE_CHECKING

from octopus.utils.logger import prettier_dict
from squirro.sdk import PipeletV1, require

if TYPE_CHECKING:
    from logging import Logger
    from typing import Any


@require("log")
class CheckItemPipelet(PipeletV1):  # type: ignore[misc]
    """Pipelet to log item for debugging."""

    log: "Logger"

    def consume(self, item: "dict[str, Any]") -> "dict[str, Any]":
        """Consume an item.

        Args:
            item: The item to consume

        Returns:
            The consumed item
        """
        self.log.info("Consuming item %s", prettier_dict(item))

        return item
