# import json
# import logging
# from unittest.mock import patch

# import pytest
# from activity_tracking_ids import ActivityTrackingIDs

# REDIS_ITEM_HASH = "item_hash"


# @patch("activity_tracking_ids.create_config_parser")
# @patch("activity_tracking_ids.redis")
# class TestActivityTrackingIDs:
#     @pytest.mark.parametrize(
#         "keywords,source_type",
#         [
#             (
#                 {
#                     "source_type": ["Email"],
#                     "user_name": ["Htet"],
#                     "user_email": ["htet.naing@dota.in"],
#                 },
#                 "Email",
#             ),
#             (
#                 {
#                     "method": ["User Upload"],
#                     "user_name": ["Htet"],
#                     "user_email": ["htet.naing@dota.in"],
#                 },
#                 "User Upload",
#             ),
#         ],
#     )
#     def test_consume(self, mock_redis, mock_config, caplog, keywords, source_type):
#         caplog.set_level(logging.INFO)

#         item_id = "123"
#         title = "Five nights at Freddy's"

#         item = {
#             "id": item_id,
#             "title": title,
#             "created_at": "2023-06-29T12:00:00",
#             "keywords": keywords,
#         }
#         metadata = {
#             "source_type": source_type,
#             "title": title,
#             "created_at": "2023-06-29 12:00:00",
#             "user_name": "Htet",
#             "user_email": "htet.naing@dota.in",
#         }

#         test_class = ActivityTrackingIDs(mock_config)
#         consumed_item = test_class.consume(item)

#         test_class.redis_client.hsetnx.assert_called_with(
#             REDIS_ITEM_HASH, item_id, json.dumps(metadata)
#         )
#         assert (
#             f"Adding item `{item_id}` to Redis hash
# `{REDIS_ITEM_HASH}`" in caplog.text
#         )
#         assert consumed_item == item
