# Store Into WFI

#### Source Codes

`ocbc-ecoffice/enrich/store_into_wfi/store_into_wfi.py`

#### Description

* Check if Squirro Item is meant for Initial Check-In, `wfi:initial_checkin` Squirro Item property
* Obtain the file to store in WFI. If OCR was applied on file, Squirro Item will retain the OCR-ed version
    * Delete the original file and remove from Squirro Item `item["files"]` property
* Check if the Squirro Item & File to Store is valid before storing into WFI.
    1. Squirro Item `title` property longer than `MAX_TITLE_LEN` - Rejection Reason: `WFI_LABEL_TOO_LONG`
    2. File to Store does not exist - Rejection Reason: `FILE_NOT_FOUND`
    3. WFI fields' value is not `string` - Rejection Reason: `WFI_LABEL_NOT_SUPPORTED`
    4. WFI fields' length of value is longer than specified - Rejection Reason: `WFI_LABEL_TOO_LONG`
* Prepare the Request Payload to check in document into WFI
    1. Remove special characters from Squirro Item `title` property, execpt for allowed characters: `_.-:,&?!'\u2019)( `
    2. If Squirro Item is meant for Initial Check-In, populate Request Payload with WFI metadata values or its default values (if not exist)
* Store into WFI via WFI API endpoint, `/checkindocument`
    * If fail, Add rejected item to Redis hash, `item_rejection_hash`, and delete the file on local filesystem.
    * Add rejected item to Redis hash, `failed_items_hash`, queue for retry
* Upon successful Store into WFI, post-process Squirro Item
    * Update Squirro Item's keywords, `wfi_document_id` & `wfi_status`
    * Delete the file on local filesystem.
    * Modify file `content_url` to point to storage plugin's URL, ensures that documents are fetched directly from WFI.
        * If document needs to be converted to PDF on the fly, also modify the `pdf_conversion` URL
    * Add the success event to Redis hash, `item_success_hash`, for [Activity Tracking](/scheduled-jobs/feature-jobs/activity-tracking.html)
