# Retry Storing into WFI

#### Source Codes

`ocbc-ecoffice/enrich/retry_storing_into_wfi/retry_storing_into_wfi.py`

#### Description

* Get from Redis, against `failed_items_hash` hash, Squirro Item's `content_url`
    * `content_url` is mapped to `title` field in dataloader
* Check if Squirro Item is Initial Check-In to WFI
* Retry storing into WFI, fails for the following condition:
    * `created_at` field is not datetime string parsable - Rejection Reason: `WFI_RETRY_CREATED_TIME_NOT_FOUND`
    * `created_at` datetime value is > 1 day ago - Rejection Reason: `CREATED_OVER_24H`
        * Set `wfi_status` keyword to `Failure`
* Upon successful Retry,
    1. Update Squirro Item's labels
    2. Delete local file
    3. Modify file's `content_url` to WFI storage plugin URL to ensure documents are fetched directly from WFI
    4. Add `Success` item entry to Redis for ingestion by [Activity Tracking](/scheduled-jobs/feature-jobs/activity-tracking.html)
    5. Delete entries from `item_rejection_hash` and `failed_items_hash` appropriately
