# Filter Items

#### Source Codes

`ocbc-ecoffice/enrich/filter_items/filter_items.py`

#### Pipelet Arguments

* Filter items from whitelisted email senders
    * Defaults to `True`
* Filter items with files exceeding provided size (MB)
    * Defaults to 50MB

#### Description

* Reject Squirro Items based on one of the following conditions:
    1. `files` property is missing from Squirro Item - Rejection Reason: `ITEM_HAS_NO_FILE`
    2. `id` property is missing from Squirro Item
    3. `files[0]` does not exist or is not a regular file - Rejection Reason: `FILE_NOT_FOUND`
    4. File is password-protected - Rejection Reason: `PASSWORD_PROTECTED`
    5. File size > configured `filter_exceeding_size_files` argument - Rejection Reason: `FILE_TOO_LARGE`
    6. File MIME type not supported - Rejection Reason: `FILE_NOT_SUPPORTED`
        * Supported MIME Types:
            * `OfficePdfConverter.SUPPORTED_MIME_TYPES`
            * `application/pdf`
            * `application/vnd.ms-outlook`
            * `image/jpeg`
            * `image/png`
            * `image/tiff`
    7. If `filter_whitelisted_senders`: `True` AND `source_type` == `Email`, Reject if `user_email` not in `_whitelisted_emails`
        * `_whitelisted_emails` is configured in `app.whitelisted-emails` configured under `Server > Settings > Project Configurations`
        * Rejection Reason: `SENDER_NOT_WHITELISTED`
