# Setup

Ensure that ansible is installed on the target server.

```bash
yum install -y ansible
```

## Configs

Create a copy of `main.template.ini` called `main.ini` and populate it with the
`project_id` with the default project that has been created.

```ini
[squirro]
project_id =

[activity]
project_id =
```

Values below would require manual user input based on information given by OCBC (random for internal use).

```ini
# common.ini
[dataloader]
exchange_tenant_id =

[proxy]
proxy =
no_proxy =
```

## Squirro Internal Servers User Setup

1. Create `wfidply` user by running `useradd wfidply`.
2. Modify `vim /etc/sudoers` as below:

```bash
...
root    ALL=(ALL)       ALL

# Add below line
wfidply ALL=(ROOT)      NOPASSWD: /apps/octopus/scripts/post_install.sh, /usr/bin/systemctl
```
