# Deployment

This serves as an internal guide to the deployment process.

## Building octopus wheel file

Any changes made to `src/octopus` would require a new wheel file to be built.
This is because OCBC environment does not has internet access and
`pip install -e .` will not work. To generate a wheel file, simply run:

```bash
make build
```

## Project Export

When changes are made on the frontend a project export is required so that it is
applied on the target servers during auto deployment through project import.

```bash
bash deployment/export_project/export_project.sh
```

## Feature Deployment

Auto-deployment with CI/CD has been setup for the project in OCBC. The pipeline
will run the `scripts/ecoffice.sh` script which triggers
`deployment/post-install.sh` to deploy the latest features to the server.
Similar approach has been setup for `octopus-stable`. To trigger an
auto-deployment, on Squirro internal server run the command below:

```bash
bash deployment/ansible/scripts/remote-feature-release.sh -l octopus-stable
```

## Code Drop @OCBC

To upload code to the mirror for OCBC to download, run the following command:

```bash
make release
scp dist/octopus.zip mirror.squirro.net:/mirror/centos/8.2/stable/x86_64/projects/ocbc-ecoffice
```
