# Ansible

## Playbooks

- `feature-deployment` is used for feature deployment
- `install-dependencies` is used for installing dependencies
- `mock-wfi` is used for mocking WFI
- `ocbc-design` is used to ensure the UI design aligns with OCBC branding
- `remote-feature-release` is used for remote feature release on Squirro server
- `security-playbook` is used deploy security related configurations

## Roles

- `common` contains common tasks that are used across different playbooks
- `feature-deployment` contains feature deployment tasks
- `mock-wfi` contains tasks for mocking WFI
- `ocbc-design` contains tasks for ensuring the UI design aligns with OCBC
  branding
- `pre-feature-deployment-adhoc` for adhoc tasks that is one-off
- `post-feature-deployment-adhoc` role for adhoc tasks that is one-off
- `remove-ootb-plugins` contains tasks for removing OOTB plugins
- `security` contains tasks for deploying security related configurations
- `setup-octopus` contains tasks for setting up 🐙
- `upload-repo` contains tasks for uploading the repo to the Squirro server
