#!/usr/bin/env bash
set -e

REDIS_STORAGE_PASSWORD="CK_CMD::jsonfile:/etc/squirro/.vault.json:redis:password"
REDIS_CACHE_PASSWORD="CK_CMD::jsonfile:/etc/squirro/.vault.json:redis_cache:password"

# Find all redis related fields
redis_storage_dbs=$(grep "^\[redis.*]" /etc/squirro/*.ini | grep -v "_cache.*]" | grep -v "redis_key_value" | sed -e "s/^.*\[//" -e "s/] *$//" | sort -u)
redis_cache_dbs=$(grep "^\[redis.*_cache.*]" /etc/squirro/*.ini | grep -v "redis_key_value" | sed -e "s/^.*\[//" -e "s/] *$//" | sort -u)
redis_key_value_dbs=$(grep "^\[redis_key_value_store.*]" /etc/squirro/*.ini | sed -e "s/^.*\[//" -e "s/] *$//" | sort -u)
redis_key_value_cache_dbs=$(grep "^\[redis_key_value_cache.*]" /etc/squirro/*.ini | sed -e "s/^.*\[//" -e "s/] *$//" | sort -u)

# Remove old redis passwords
sed -e "/^password *=/d" -i /etc/squirro/*.ini
sed -e "/^redis_password *=/d" -i /etc/squirro/*.ini

# Update redis passwords
for storage_db in $redis_storage_dbs; do
	sed "s|^\(\[${storage_db}] *\)$|\1\npassword = $REDIS_STORAGE_PASSWORD|" -i /etc/squirro/*.ini
done

for cache_db in $redis_cache_dbs; do
	sed "s|^\(\[${cache_db}] *\)$|\1\npassword = $REDIS_CACHE_PASSWORD|" -i /etc/squirro/*.ini
done

for storage_db in $redis_key_value_dbs; do
	sed "s|^\(\[${storage_db}] *\)$|\1\nredis_password = $REDIS_STORAGE_PASSWORD|" -i /etc/squirro/*.ini
done

for cache_db in $redis_key_value_cache_dbs; do
	sed "s|^\(\[${cache_db}] *\)$|\1\nredis_password = $REDIS_CACHE_PASSWORD|" -i /etc/squirro/*.ini
done

# Update [queues_local] section in common.ini if it exists
if grep -Fxq "[queues_local]" /etc/squirro/common.ini; then
	sed "s|^\(\[queues_local] *\)$|\1\nredis_password = $REDIS_STORAGE_PASSWORD|" -i /etc/squirro/common.ini
else
	cat >>/etc/squirro/common.ini <<FOO

[queues_local]
redis_password = $REDIS_STORAGE_PASSWORD
FOO
fi
