#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source /opt/squirro/virtualenv311/bin/activate

# Update /etc/sysconfig/squirro SQ_DECRYPT_COMMAND=? to fetch_ck_cmd_values.sh
# This is to ensure that the command to decrypt the secrets is updated
# in the /etc/sysconfig/squirro file.
sed -i 's/SQ_DECRYPT_COMMAND=.*/SQ_DECRYPT_COMMAND=\/opt\/squirro\/octopus\/deployment\/vault\/fetch_ck_cmd_values\/fetch_ck_cmd_values.sh/g' \
	/etc/sysconfig/squirro

python init_vault.py
./standardize-redis-password.sh

# Ensure the permissions are set correctly
chown root:squirro /etc/squirro/.vault.json /etc/squirro/.squirro.key
chmod 640 /etc/squirro/.vault.json /etc/squirro/.squirro.key
