"""Update status permissions."""

import json
from pathlib import Path

from octopus.clients import init_redis_client


def main() -> None:
    """Entrypoint."""
    redis_client = init_redis_client()

    with Path("../../integration/studio/status_permissions/permissions.json").open(
        encoding="utf-8"
    ) as f:
        data = json.load(f)
        redis_client.set("status_permissions", json.dumps(data))


if __name__ == "__main__":
    main()
