"""Update email notification config."""

import json
from pathlib import Path

from octopus.clients import init_redis_client


def main() -> None:
    """Entrypoint."""
    redis_client = init_redis_client()

    with Path("configs/distribution_list.json").open(encoding="utf-8") as f:
        data = json.load(f)
        redis_client.hset("email_notifications", "distribution_list", json.dumps(data))

    with Path("configs/triggers.json").open(encoding="utf-8") as f:
        data = json.load(f)
        redis_client.hset("email_notifications", "triggers", json.dumps(data))


if __name__ == "__main__":
    main()
