#!/usr/bin/env bash
set -e

# Create a temporary file
config="/etc/redis/redis.conf.tmp"

# Substitute environment variables in the configuration file and write the
# result to the temporary file
password=$(echo -n jsonfile:/etc/squirro/.vault.json:redis:password |
	bash /opt/squirro/octopus/deployment/vault/fetch_ck_cmd_values/fetch_ck_cmd_values.sh)
REDIS_PASSWORD="${password}" envsubst </etc/redis/redis.conf >"${config}"

# Start the Redis server with the temporary configuration file
exec /usr/bin/redis-server "${config}" \
	--supervised systemd \
	--daemonize no
