#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"

# Replace the default configuration files with the ones from the repository
cp -f "services/redis-server.service" /usr/lib/systemd/system
cp -f "services/redis-server-cache.service" /usr/lib/systemd/system
if [ -f "/etc/redis/sentinel.conf" ]; then
	cp -f "services/redis-sentinel.service" /usr/lib/systemd/system
fi

# Replace password in /etc/redis/*.conf with "${REDIS_PASSWORD}"
sed -i /etc/redis/*.conf \
	-e "s/^requirepass .*/requirepass \${REDIS_PASSWORD}/" \
	-e "s/^masterauth .*/masterauth \${REDIS_PASSWORD}/"

chown redis:redis -R /etc/redis

# Restart redis services
systemctl daemon-reload
systemctl restart redis-server
systemctl restart redis-server-cache
if [ -f "/etc/redis/sentinel.conf" ]; then
	systemctl restart redis-sentinel
fi
