#!/usr/bin/env bash
set -e
OPT_SQ=/opt/squirro
LOG_DIR="/apps/octopus/logs/post-install"
PROJECT_ROOT="${OPT_SQ}"/octopus

# Route all output to a log file
mkdir -p "${LOG_DIR}"
exec > >(tee -i "${LOG_DIR}/$(date +%Y%m%d_%H%M%S).log")
exec 2>&1

# /apps/DEVOPS/?
# |- script/ecoffice.sh
# |- app/
echo "Update ${PROJECT_ROOT} with latest changes"
cp -r "${PROJECT_ROOT}/config" /tmp
rsync -av --checksum --delete --exclude='config' app/ "${PROJECT_ROOT}"
chown -R root:squirro "${PROJECT_ROOT}"
chmod -R 750 "${PROJECT_ROOT}"

echo "Entering ${PROJECT_ROOT}..."
cd "${PROJECT_ROOT}"

echo "Running feature deployment playbook..."
./deployment/ansible/scripts/feature-deployment.sh -l localhost -vv
exit_code=$?

chown wfiecousr:squirro -R "${LOG_DIR}"

exit ${exit_code}
