#!/usr/bin/env bash
set -e
cd "$(dirname "$0")/../.."

mkdir -p "/opt/squirro/virtualenv311/patches"

apply_patch() {
	local patch_name=$1
	echo "Applying ${patch_name} patch"
	bash common/deployment/apply_patch "deployment/patches/${patch_name}.patch"
}

echo "Clearing .applied to force patching"
rm -f "/opt/squirro/virtualenv311/patches/.applied"

# Find all .orig files and loop through them and undo the patch
find "/opt/squirro/virtualenv311" -type f -name "*.orig" | while read -r orig_file; do
	patched_file="${orig_file%.orig}"
	echo "Restoring original file from $orig_file to $patched_file"
	mv -f "$orig_file" "$patched_file"
done

apply_patch "squirro-platform"
apply_patch "squirro-integration"
apply_patch "squirro-common"
apply_patch "email-loader-3.10.6"
