"""Project import."""

import logging

from octopus.clients import init_squirro_client
from octopus.utils import set_log_verbosity

set_log_verbosity(logging.INFO)


def main() -> None:
    """Entrypoint."""
    for project in ["octopus", "activity"]:
        logging.info("Importing %s project", project)
        project_section = "squirro" if project == "octopus" else project
        sq_client, project_id = init_squirro_client(project=project_section)
        sq_client.import_project(
            project_id,
            f"../../assets/project_exports/{project}.tar.gz",
            import_ais_published_models=True,
            import_app_nav_bar=True,
            import_communities=True,
            import_community_types=True,
            import_dashboard_loaders=True,
            import_dashboard_widgets=True,
            import_dashboards=True,
            import_default_sort=True,
            import_email_templates=True,
            import_enrichment_pipelets=True,
            import_enrichments=True,
            import_facets=True,
            import_guide_file=True,
            import_items=True,
            import_machinelearning_jobs=True,
            import_machinelearning_models=True,
            import_machinelearning_workflows=True,
            import_pipeline_workflows=True,
            import_project_configuration=True,
            import_project_picture=True,
            import_project_translations=True,
            import_smartfilters=True,
            import_sources=True,
            import_sources_dataloader_plugins=True,
            import_synonyms=True,
            import_trends=True,
        )

        logging.info("Imported %s project", project)


if __name__ == "__main__":
    main()
