import json
from pathlib import Path
from unittest.mock import MagicMock, patch

from document_type_hash import main


def test_main(mock_redis_client, caplog):
    mock_path = MagicMock(spec=Path)
    mock_path.open.return_value.__enter__.return_value = MagicMock()
    mock_path.open.return_value.__enter__.return_value.read.return_value = json.dumps(
        {"key": "value"}
    )
    with patch("document_type_hash.Path", return_value=mock_path):
        main()

    mock_redis_client.exists.assert_called_once_with("document_type_mapping_hash")
    mock_redis_client.delete.assert_called_once_with("document_type_mapping_hash")
    mock_redis_client.hset.assert_called_once_with(
        "document_type_mapping_hash", "key", json.dumps("value")
    )
    assert "Writing mappings to Redis." in caplog.text
    assert "Completed." in caplog.text
