"""Document type hash."""

import json
import logging
from pathlib import Path

from octopus.clients import init_redis_client
from octopus.utils import set_log_verbosity

set_log_verbosity(logging.INFO)


def main() -> None:
    """Entrypoint."""
    redis_client = init_redis_client()

    if redis_client.exists("document_type_mapping_hash"):
        logging.warning("Deleting existing document_type_mapping_hash")
        redis_client.delete("document_type_mapping_hash")

    # Load mappings.json
    path = Path("mapping.json")
    with path.open("r", encoding="utf-8") as f:
        mappings: dict[str, str | bool] = json.load(f)

    # Save mappings to Redis
    logging.info("Writing mappings to Redis.")
    for k, v in mappings.items():
        redis_client.hset("document_type_mapping_hash", k, json.dumps(v))

    logging.info("Completed.")


if __name__ == "__main__":
    main()
