"""Create a user group in Squirro."""

import logging

from octopus.clients import init_squirro_client
from octopus.utils import set_log_verbosity

set_log_verbosity(logging.INFO)


def main(group_name: str) -> None:
    """Entrypoint."""
    logging.info("Creating user group")
    sq_client, _ = init_squirro_client()

    if any(
        single_group_info["name"] == group_name
        for single_group_info in sq_client.get_groups()
    ):
        logging.info("Group already exists")
        return

    sq_client.create_group(group_name)

    logging.info("User group created")


if __name__ == "__main__":
    import sys

    main(sys.argv[1])
