#!/usr/bin/env bash
set -e
SQPASSWORD="squirro/4u"

sq_users_dbs=('configuration' 'datasource' 'emailsender' 'filtering' 'fingerprint' 'machinelearning' 'notes' 'plumber' 'scheduler' 'studio' 'topic' 'trends' 'user')
for sq_user_db in "${sq_users_dbs[@]}"; do
	# (escaped) quotes needed because 'user' is a reserved word
	echo "Creating role ${sq_user_db} and database ${sq_user_db}"
	psql \
		-c "create role \"${sq_user_db}\" with login password '${SQPASSWORD}';" \
		-c "create database \"${sq_user_db}\" with owner \"${sq_user_db}\";"
done
