#!/usr/bin/env bash

# Define the directories to search
DIRS=(
	"/etc/squirro"
	"/etc/nginx"
	"/etc/elasticsearch"
)

# Loop through each directory
for DIR in "${DIRS[@]}"; do
	# Check if the directory exists
	if [ -d "${DIR}" ]; then
		# Find all files in the directory and its subdirectories
		FULLPATH=$(realpath "${DIR}")
		find "${FULLPATH}" -type f -exec sed -i 's|/var/log|/apps/squirro/var/log|g' {} +
	else
		echo "Directory $DIR does not exist, skipping..."
	fi
done

echo 'SQUIRRO_LOG_PATH=/apps/squirro/var/log/squirro' >>/etc/sysconfig/squirro

echo "Replacement complete."
