#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"

# Get full path to ./dist
ROOT="$(pwd)/../../.."
DIST="${ROOT}/dist"

# Remove old files
rm -rf /tmp/oct
mkdir -p /tmp/oct
rm -rf "${DIST}"
mkdir -p "${DIST}"

# Archive main repo
cd "${ROOT}"
git archive --format=zip -o /tmp/oct/octopus.zip HEAD

# Archive submodules
# shellcheck disable=SC2016
git submodule foreach --recursive \
	'git archive --prefix=$path/ --format zip HEAD --output /tmp/oct/$sha1.zip'

# Merge archives
cd /tmp/oct
for zip_file in /tmp/oct/*.zip; do
	unzip -q "${zip_file}" -d .
	rm "${zip_file}"
done
zip -qr "${DIST}/octopus.zip" .

# Delete selected files which gets flagged at OCBC from the archive
files_to_exclude=(
	"common/config/merge_json_config.py"
	"src/docs/*"
	"src/mock_wfi/*"
)

common_folders=$(
	unzip -l "${DIST}/octopus.zip" |
		awk '{print $4}' |
		grep -E "^common/[^/]+/" |
		grep -Ev "common/config/|common/lib/" |
		sort -u
)

for folder in $common_folders; do
	if [ -n "$folder" ]; then
		files_to_exclude+=("${folder}")
	fi
done

for file in "${files_to_exclude[@]}"; do
	zip -d "${DIST}/octopus.zip" "${file}" || true
done

# Add the specific file common/deployment/apply_patch to the archive
cd "${ROOT}"
zip -g "${DIST}/octopus.zip" "common/deployment/apply_patch"
