# Ansible

## Setup

Pull the latest repository locally and run `make release` to generate the
latest archive. This archive will be used for deployment. Place the archive on
the server under `/opt/squirro/octopus`.

```bash
cd /opt/squirro/octopus/deployment/ansible

# For Squirro internal node, at the end include `-e "internal_node=true"`
ansible-playbook -l localhost playbooks/setup-octopus.yml

# For Squirro internal node, deploy mocked WFI API from local as the file will
# be removed from the archive export using `make release` due to security
# concerns.
bash src/mock_wfi/upload.sh
```

## Remote Feature Deployment

Auto-deployment with CI/CD has been setup for the project in OCBC. The pipeline
will run the `scripts/ecoffice.sh` script which triggers
`deployment/post-install.sh` to deploy the latest features to the server.
Similar approach has been setup for all internal servers. To trigger an
auto-deployment, on Squirro internal server run the command below:

```bash
cd deployment/ansible
ansible-playbook playbooks/remote-feature-release.yml -l octopus-stable -K
```

## Storage Node setup

- If security is enabled, generate certificates for the nodes following this
[guide][squirro-secure-elastic]

### Internal multi nodes

For internal multi-nodes, only `10.0.2.x` IPs under network enp7s0 are allowed
for ES, but however ES by default tries all IP. To restrict ES to only
`10.0.2.x` IPs, add the below to `elasticsearch.yml` and restart ES.

```yml
transport.publish_host: 10.0.2.x
```

## Remote PostgreSQL

OCBC has provided a remote PostgreSQL database for the project. To stimulate
this setup, a plain PostgreSQL container is used instead of a proper setup.
For testing purposes, this is ran on `ocbc-dev-sn-2` on internal test playbooks.
PostgreSQL has to be manually configured when using this setup using the script
`deployment/ansible/scripts/postgres-configure-squirro-users.sh`.

```bash
docker run -d \
  -e POSTGRES_HOST_AUTH_METHOD=trust \
  -p 5432:5432 \
  --name postgres
  postgres:bullseye
```

<!-- references -->
[squirro-secure-elastic]: https://docs.squirro.com/en/latest/getting/install/ansible/elasticsearch-tls.html
