#!/usr/bin/env bash
cd "$(dirname "$0")"
set -e
source ../../common/config/config.sh
source /etc/profile.d/squirro-python.sh

timestamp=$(date +%s)

log_dir="logs"
mkdir -p "${log_dir}"

# Clear logs older than 30 days
# shellcheck disable=SC2038
find "${log_dir}" -type f -mtime +30 | xargs rm -f

if [ $# -eq 0 ]; then
	n_csv_items=500
else
	n_csv_items=$1
fi
echo "Uploading ${n_csv_items} historic data..."

squirro_data_load -v \
	--token "$(getval token squirro)" \
	--cluster "$(getval cluster squirro)" \
	--project-id "$(getval project_id squirro)" \
	--source-name "WFI Historic" \
	--source-script "wfi_loader_plugin.py" \
	--pipeline-workflow-name "WFI" \
	--facets-file facets_historic.json \
	--map-id "wfi_document_id" \
	--map-title "filename" \
	--map-body-mime "contentType" \
	--map-file-name "filename" \
	--map-file-data "contentBytes" \
	--map-file-mime "contentType" \
	--csv-path "$(getval wfi_client_root wfi)"/"$(getval historic_csv_file wfi)" \
	--batch-size 10 \
	--source-batch-size 10 \
	--n-csv-items "$n_csv_items" 2>&1 |
	tee -a "${log_dir}/wfi_loader_historic_${timestamp}.log"
