#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../common/config/config.sh

# Folders to upload
folders=(
	"exchange_plugin"
	"custom_activity_plugin"
	"retry_plugin"
	"wfi_loader"
)

for folder in "${folders[@]}"; do
	# Check if folder is a directory
	if [[ -d "${folder}" ]]; then
		# Check if folder contains a upload.sh script
		if [[ -f "${folder}/upload.sh" ]]; then
			bash "${folder}/upload.sh"
		fi
	fi
done
