#!/usr/bin/env bash
set -e
cd "$(dirname "$0")"
source ../../common/config/config.sh

for folder in *; do
	# Check if folder is a directory
	if [[ -d "${folder}" ]]; then
		# Check if folder contains a upload.sh script
		if [[ -f "${folder}/upload.sh" ]]; then
			echo "Uploading ${folder}..."
			bash "${folder}/upload.sh"
		fi
	fi
done
