const Action = (props) => {
  const {
    keywordsToExport,
    useGlobalSearchQuery,
    additionalQuery,
    buttonText,
  } = Globals.widgetConfig;
  const globalSearch = useGlobalSearchQuery ? App.globalSearch : null;

  const saveToExcel = () => {
    const query =
      getCurrentQuery(globalSearch, Globals.dashboardState) +
      " " +
      (additionalQuery || "");

    const parameters = {
      project_id: Globals.project.attributes.id,
      count: 10000,
      excel: true,
      options: {},
      child_count: 100,
      query: query ? query : "",
      keywords: JSON.stringify(keywordsToExport),
      dashboard:
        Globals.dashboardState.options.dashboard.getTitle() || "Squirro",
    };

    const url = "/v0/items/query?" + $.param(parameters);
    window.open(url, "_blank");
  };

  return (
    <Overrides.Actions.Action
      {...props}
      label={buttonText || props.label}
      onClick={props.label === "Save to Excel" ? saveToExcel : props.onClick}
    />
  );
};

const overrides = {
  ...Overrides.Actions,
  Action: Action,
};

export default (props) => {
  return (
    <div>
      <Widgets.Actions {...props} overrides={overrides} />
    </div>
  );
};

const getCurrentQuery = (globalSearch, dashboardState) => {
  const dashboardQuery = dashboardState.getQuery();
  let query = "";

  if (!_.isEmpty(globalSearch?.getQuery())) {
    query = globalSearch.getQuery();
  } else {
    query = dashboardQuery;
  }

  if (!query.includes(dashboardQuery)) {
    query = `${dashboardQuery} ${query}`;
  }

  const hasTimeSelections = dashboardState.hasTime();
  if (hasTimeSelections) {
    const timeStart = dashboardState.getTime("start");
    const isTimeStartRelative =
      dashboardState.getParsedTime("start").type === "relative";
    const formattedTimeStart = isTimeStartRelative
      ? `now-${timeStart}`
      : timeStart;
    const timeEnd = dashboardState.getTime("end");

    if (timeStart && timeStart !== "allTime") {
      query += ' ($item_created_at >= "' + formattedTimeStart + '")';
    }
    if (timeEnd) {
      query += ' ($item_created_at < "' + timeEnd + '")';
    }
  }

  return query.trim();
};
