const formatTimestamp = (timestamp, format = "DD/MM/YYYY HH:mm:ss") =>
  moment(timestamp + "Z").format(format);

const getCurrentQuery = (globalSearch, dashboardState) => {
  const dashboardQuery = dashboardState.getQuery();
  let query = globalSearch.get("query") || dashboardQuery;

  if (!query.includes(dashboardQuery)) {
    query = `${dashboardQuery} ${query}`;
  }

  if (dashboardState.hasTime()) {
    const timeStart = dashboardState.getTime("start");
    const isTimeStartRelative =
      dashboardState.getParsedTime("start").type === "relative";
    const formattedTimeStart = isTimeStartRelative
      ? `now-${timeStart}`
      : timeStart;
    const timeEnd = dashboardState.getTime("end");

    if (timeStart && timeStart !== "allTime") {
      query += ' ($item_created_at >= "' + formattedTimeStart + '")';
    }
    if (timeEnd) {
      query += ' ($item_created_at < "' + timeEnd + '")';
    }
  }

  return query.trim();
};

const getEditDeletePermissions = (user, editDeletePermissions, item) => {
  const isAdmin = user?.role === "admin";
  const userEmail = user?.user_information?.email?.[0].toLowerCase();
  const {
    current_doc_status: curStatus,
    prev_doc_status: prevStatus,
    prev_updater: prevUpdater,
    uploader_role: uploaderRole,
    user_email: uploaderEmail,
  } = item?.keywords;

  const permission =
    editDeletePermissions?.[curStatus?.[0]]?.[prevStatus?.[0]]?.[
      uploaderRole?.[0]
    ];
  const restrictNonUploader =
    permission?.uploader_only && userEmail !== uploaderEmail?.[0].toLowerCase();
  const restrictPrevUpdater =
    permission?.previous_updater_only &&
    userEmail !== prevUpdater?.[0].toLowerCase();

  const canEdit =
    isAdmin ||
    (!restrictNonUploader && !restrictPrevUpdater && permission?.edit);
  const canDelete =
    isAdmin ||
    (!restrictNonUploader && !restrictPrevUpdater && permission?.delete);

  return { canEdit, canDelete };
};

export default {
  formatTimestamp,
  getCurrentQuery,
  getEditDeletePermissions,
};
