const SnackbarContext = React.createContext();

function SlideTransition(props) {
  return <MUI.Slide {...props} direction="down" />;
}

const SnackbarProvider = ({ children }) => {
  const [snackbarConfig, setSnackbarConfig] = React.useState({
    message: "",
    open: false,
    severity: "",
  });

  const handleClose = (event, reason) => {
    if (reason === "clickaway") {
      return;
    }
    setSnackbarConfig({
      ...snackbarConfig,
      open: false,
    });
  };

  const showSnackbar = (message, severity) => {
    setSnackbarConfig({
      message,
      open: true,
      severity,
    });
  };

  return (
    <SnackbarContext.Provider value={{ showSnackbar }}>
      <MUI.Box sx={{ position: "absolute", zIndex: 1600 }}>
        <MUI.Snackbar
          open={snackbarConfig.open}
          anchorOrigin={{ vertical: "top", horizontal: "center" }}
          autoHideDuration={3000}
          onClose={handleClose}
          TransitionComponent={SlideTransition}
        >
          <MUI.Alert
            onClose={handleClose}
            severity={snackbarConfig.severity}
            variant="filled"
            sx={{ width: "100%" }}
          >
            {snackbarConfig.message}
          </MUI.Alert>
        </MUI.Snackbar>
      </MUI.Box>
      {children}
    </SnackbarContext.Provider>
  );
};

const useSnackbar = () => React.useContext(SnackbarContext);

export default { SnackbarProvider, useSnackbar };
