const GenerateLabel = () => {
  const item = React.useContext(ModelContexts.Items);
  const { generateLabel } = Resources.resolved["api.js"];

  const isDisabled = !item.keywords.company_name?.[0];
  const generateLabelAction = () => generateLabel(item.project_id, item.id);

  return (
    <>
      <MUI.Tooltip
        title={"Cover Page" + (isDisabled ? " (Missing Company Name)" : "")}
        placement="top"
        arrow
        TransitionComponent={MUI.Zoom}
      >
        <span>
          <MUI.IconButton
            disabled={isDisabled}
            onClick={generateLabelAction}
            size="small"
          >
            <MUI.Icon color={isDisabled ? "disabled" : ""}>assignment</MUI.Icon>
          </MUI.IconButton>
        </span>
      </MUI.Tooltip>
    </>
  );
};

export default GenerateLabel;
