const EditInformation = ({ disabled, disabledTooltip }) => {
  const EditForm = Resources.resolved["EditForm.js"];
  const [isModalOpen, setIsModalOpen] = React.useState(false);
  const item = React.useContext(ModelContexts.Items);

  const handleOpen = (e) => {
    e.stopPropagation();
    setIsModalOpen(true);
  };

  const handleClose = (e) => {
    e.stopPropagation();
    setIsModalOpen(false);
  };

  return (
    <>
      <MUI.Tooltip
        title={!disabled ? "Edit" : disabledTooltip}
        placement="top"
        arrow
        TransitionComponent={MUI.Zoom}
      >
        <span>
          <MUI.IconButton disabled={disabled} size="small" onClick={handleOpen}>
            <MUI.Icon color={disabled ? "disabled" : ""}>edit</MUI.Icon>
          </MUI.IconButton>
        </span>
      </MUI.Tooltip>
      <MUI.Modal open={isModalOpen} onClose={handleClose}>
        <div>
          <EditForm item={item} handleClose={handleClose} />
        </div>
      </MUI.Modal>
    </>
  );
};

export default EditInformation;
