const DownloadDocument = () => {
  const item = React.useContext(ModelContexts.Items);
  const widget = React.useContext(WidgetContexts.Items);
  const { useSnackbar } = Resources.resolved["hooks.js"];
  const { showSnackbar } = useSnackbar();

  const wfiDocumentId = item.keywords?.wfi_document_id?.[0];
  const { project } = widget.hasOwnProperty("mainJsProps")
    ? widget.mainJsProps
    : widget;

  const url = `/studio/storage/wfi/download/${project.id}/${wfiDocumentId}`;

  return (
    <>
      <MUI.Tooltip
        title="Download"
        placement="top"
        arrow
        TransitionComponent={MUI.Zoom}
      >
        {wfiDocumentId ? (
          <MUI.IconButton href={url} size="small" target="_blank">
            <MUI.Icon>download</MUI.Icon>
          </MUI.IconButton>
        ) : (
          <MUI.IconButton
            size="small"
            onClick={() =>
              showSnackbar(
                "Document has not been stored into WFI. Please try again later.",
                "error",
              )
            }
          >
            <MUI.Icon>download</MUI.Icon>
          </MUI.IconButton>
        )}
      </MUI.Tooltip>
    </>
  );
};

export default DownloadDocument;
