export default (props) => {
  const model = React.useContext(ModelContexts.Items);
  const widget = React.useContext(WidgetContexts.Items);
  const { additionalWidgetConfig } = widget.mainJsProps;

  const document_type_pred_ml = model.keywords?.document_type_pred_ml?.[0];
  const document_type_true = model.keywords?.document_type_true?.[0];

  const isCorrect = document_type_pred_ml === document_type_true;
  const color = isCorrect ? "green" : "red";

  return (
    <CardTitle
      {...props}
      {...(additionalWidgetConfig.markCorrectPredictions ? { color } : {})}
    />
  );
};

const CardTitle = styled(Overrides.Items.CardTitle)({
  maxHeight: "none",
  WebkitLineClamp: "5",
});
