export default (props) => {
  const item = React.useContext(ModelContexts.Items);
  const wfiStatus = item.keywords?.wfi_status?.[0];
  const zipReference = item.keywords?.zip_reference?.[0];

  return (
    <MUI.Box sx={{ display: "flex", alignItems: "center" }}>
      <Overrides.Items.CardMetadata {...props} read={undefined} />
      {zipReference && (
        <AdditionalMetadata
          icon="folder_zip"
          text={zipReference.split("|")[0]}
        />
      )}
      {wfiStatus === "Failure" && (
        <AdditionalMetadata icon="error" text="WFI Upload Failed" />
      )}
    </MUI.Box>
  );
};

const AdditionalMetadata = ({ icon, text, showDivider = true }) => {
  return (
    <>
      {showDivider && (
        <MUI.Divider
          flexItem
          orientation="vertical"
          sx={{ my: 0, mx: 1 }}
          variant="middle"
        />
      )}
      <MUI.Box sx={{ display: "flex", alignItems: "center" }}>
        <MUI.Icon
          fontSize="small"
          sx={{ color: theme.palette.text.secondary, mr: 1 }}
        >
          {icon}
        </MUI.Icon>
        <MUI.Typography
          color="text.secondary"
          sx={{ whiteSpace: "nowrap" }}
          variant="caption"
        >
          {text}
        </MUI.Typography>
      </MUI.Box>
    </>
  );
};
