export default (props) => {
  const EditInformation = Resources.resolved["EditInformation.js"];
  const DeleteOrRestoreDocument =
    Resources.resolved["DeleteOrRestoreDocument.js"];
  const DownloadDocument = Resources.resolved["DownloadDocument.js"];
  const GenerateLabel = Resources.resolved["GenerateLabel.js"];
  const { getEditDeletePermissions } = Resources.resolved["utils.js"];

  const widget = React.useContext(WidgetContexts.Items);
  const { user } = widget.mainJsProps;
  const isAdmin = user?.role === "admin";

  const { showDownloadIcon, showEditIcon, showCoverPageIcon, showDeleteIcon } =
    widget.mainJsProps?.additionalWidgetConfig;

  // Status based permissions
  const { editDeletePermissions } = widget.mainJsProps;
  const item = React.useContext(ModelContexts.Items);
  const { canEdit, canDelete } = getEditDeletePermissions(
    user,
    editDeletePermissions,
    item,
  );

  return (
    <Overrides.Items.CardActions
      {...props}
      AddToCollectionButton={false}
      CollectionsDropdown={false}
    >
      {(isAdmin || showDownloadIcon) && <DownloadDocument />}
      {(isAdmin || showEditIcon) && (
        <EditInformation
          disabled={!canEdit}
          disabledTooltip="You do not have permission to perform this action"
        />
      )}
      {showCoverPageIcon && <GenerateLabel />}
      {(isAdmin || showDeleteIcon) && (
        <DeleteOrRestoreDocument
          disabled={!canDelete}
          disabledTooltip="You do not have permission to perform this action"
        />
      )}
    </Overrides.Items.CardActions>
  );
};
