export default (props) => {
  const widget = React.useContext(WidgetContexts.Items);
  const { itemsSelectedBulkAssign } = widget.mainJsProps;
  const item = React.useContext(ModelContexts.Items);

  const isSelected = itemsSelectedBulkAssign.selectedIds.has(item.id);
  const isDeleted =
    widget.customProps?.isDeleted && widget.customProps.isDeleted.has(item.id);

  return <Card {...props} isDeleted={isDeleted} isSelected={isSelected} />;
};

const Card = styled(Overrides.Items.Card)(
  ({ theme, isDeleted, isSelected }) => ({
    display: isDeleted ? "none" : "",
    backgroundColor: isSelected ? theme.palette.hover : "white",
  }),
);
